unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, OpenGL, StdCtrls, ExtCtrls, Math;

type
  TForm1 = class(TForm)
    Timer1: TTimer;
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Timer1Timer(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormMouseWheel(Sender: TObject; Shift: TShiftState;
      WheelDelta: Integer; MousePos: TPoint; var Handled: Boolean);
  private
    { Private declarations }
    uchwytDC :HDC; //uchwyt do "display device context (DC)"
    uchwytRC :HGLRC; //uchwyt do "OpenGL rendering context"
    Phi, Theta :Single;
    PozycjaX, PozycjaY, PozycjaZ :Single;
    RuchKamery :Boolean;
    KameraX, KameraY, KameraZ :Single;
    function GL_UstalFormatPikseli(uchwytDC :HDC) :Boolean;
    procedure GL_UstawienieSceny;
    procedure Rysuj;
    procedure RysujOstroslup(x0,y0,z0 :Single);
    procedure RysujOsie(rozmiar :Single);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

function TForm1.GL_UstalFormatPikseli(uchwytDC :HDC) :Boolean;
{const OpisFormatuPikseli :PIXELFORMATDESCRIPTOR=(
        nSize:      sizeof(PIXELFORMATDESCRIPTOR);	// wielko
        nVersion:   1;			// wersja
        dwFlags:    PFD_SUPPORT_OPENGL or PFD_DRAW_TO_WINDOW or PFD_DOUBLEBUFFER;	// udostpnienie podwjnego buforowania
        iPixelType: PFD_TYPE_RGBA;	// typ koloru
        cColorBits: 24;			// dana rozdzielczo koloru
        cRedBits:   0;  cRedShift:  0;	// bity koloru(ignorowane)
        cGreenBits: 0;  cGreenShift:0;
        cBlueBits:  0;  cBlueShift: 0;
        cAlphaBits: 0;  cAlphaShift:0;   // wyczenie buforu alfa
        cAccumBits: 0;
        cAccumRedBits:    0;  		// wyczenie akumulacji bufora
        cAccumGreenBits:  0;     	// akumulowanie bitw (ignorowane)
        cAccumBlueBits:   0;
        cAccumAlphaBits:  0;
        cDepthBits:       16;			// wielko bufora
        cStencilBits:     0;			// bez buforu szablonu
        cAuxBuffers:      0;			// bez buforu pomocniczego
        iLayerType:       PFD_MAIN_PLANE;  	// gwna powoka
   bReserved:       0;
   dwLayerMask:     0;
   dwVisibleMask:   0;
   dwDamageMask:    0;  // brak widocznoci powoki, zniszczenie maski
   );}
var
  opisFormatuPikseli :PIXELFORMATDESCRIPTOR;
  formatPikseli :Integer;
begin
Result:=False;
with opisFormatuPikseli do
  begin
  dwFlags:=PFD_SUPPORT_OPENGL or PFD_DRAW_TO_WINDOW or PFD_DOUBLEBUFFER;	//w oknie, podwojne buforowanie
  iPixelType:=PFD_TYPE_RGBA; //typ koloru RGB
  cColorBits:=32; //jakosc kolorw 4 bajty
  cDepthBits:=16; //glebokosc bufora Z (z-buffer)
  iLayerType:=PFD_MAIN_PLANE;
  end;
formatPikseli:=ChoosePixelFormat(uchwytDC, @opisFormatuPikseli);
if (formatPikseli=0) then Exit;
if (SetPixelFormat(uchwytDC, formatPikseli, @opisFormatuPikseli) <> True) then Exit;
Result:=True;
end;

procedure TForm1.GL_UstawienieSceny;
begin
//ustawienie punktu projekcji
glMatrixMode(GL_PROJECTION); //macierz projekcji
//left,right,bottom,top,znear,zfar
glFrustum(-0.1, 0.1, -0.1, 0.1, 0.3, 25.0); //mnozenie macierzy przez macierz perspektywy
glMatrixMode(GL_MODELVIEW); //powrot do macierzy widoku
glEnable(GL_DEPTH_TEST); //z-buffer aktywny = ukrywanie niewidocznych trojkatow !!!
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  polozenieMyszy :TPoint;
begin
//biezace okno staje sie oknem OpenGL
uchwytDC:=GetDC(Handle);
GL_UstalFormatPikseli(uchwytDC);
uchwytRC:=wglCreateContext(uchwytDC);
wglMakeCurrent(uchwytDC,uchwytRC);
GL_UstawienieSceny;
Caption:='OpenGL '+glGetString(GL_VERSION);


KameraZ:=10;
RuchKamery:=True;
polozenieMyszy.X:=ClientWidth div 2;
polozenieMyszy.Y:=ClientHeight div 2;
if RuchKamery then Mouse.CursorPos:=ClientToScreen(polozenieMyszy);
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
wglMakeCurrent(0,0);
wglDeleteContext(uchwytRC);
ReleaseDC(Handle,uchwytDC);
PostQuitMessage(0);
end;

procedure TForm1.RysujOstroslup(x0,y0,z0 :Single);
begin
//Rysowanie trojkatow
glBegin(GL_TRIANGLES);
//glBegin(GL_LINE_LOOP);
//ustalanie trzech wierzcholkow trojkata (werteksow (x,y,z))
//(0,0,???) jest mniej wiecej w srodku ekranu

//sciana przednia
glColor3ub(255,255,0); //zolty
glVertex3f( -x0, -y0, z0); //dolny lewy
glVertex3f(x0, -y0, z0); //dolny prawy
glVertex3f(0, y0, z0); //gorny

//podstawa
glColor3ub(0,255,0); //zielony
glVertex3f( -x0, -y0, z0); //dolny lewy
glVertex3f(x0, -y0, z0); //dolny prawy
glVertex3f(0, -y0, 2*z0); //dolny tylny

//tylna lewa
glColor3ub(255,0,0); //czerwony
glVertex3f( -x0, -y0, z0); //dolny lewy
glVertex3f(0, -y0, 2*z0); //dolny tylny
glVertex3f(0, y0, z0); //gorny

//tylna lewa
glColor3ub(0,0,255); //niebieski
glVertex3f(x0, -y0, z0); //dolny prawy
glVertex3f(0, -y0, 2*z0); //dolny tylny
glVertex3f(0, y0, z0); //gorny

//koniec rysowania figury
glEnd;
end;

procedure TForm1.RysujOsie(rozmiar :Single);
begin
glBegin(GL_LINES);
glColor3ub(255,255,255);
glVertex3f(0,0,0); glVertex3f(rozmiar,0,0); //OX, w prawo
glVertex3f(0,0,0); glVertex3f(0,rozmiar,0); //OY, do gory
glVertex3f(0,0,0); glVertex3f(0,0,rozmiar); //OZ, w glab
glEnd;

end;

procedure TForm1.Rysuj;
const x0=1.0; y0=1.5; z0=1.0;
begin
//Przygotowanie bufora
glClear(GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT);
glLoadIdentity; //biezaca macierz = I
//glTranslatef(0.0, 0.0, -10.0); //odsuniecie calosci o 10

gluLookAt(KameraX,KameraY,KameraZ,  //polozenie oka
          0,0,0,  //polozenie srodka ukladu wsp.
          0,1,0); //kierunek "do gory"

RysujOsie(x0);

//obroty
glRotatef(Phi, 0.0, 1.0, 0.0); //wokol OY
glRotatef(Theta, 1.0, 0.0, 0.0); //wokol OX

//przesuniecia
glTranslatef(PozycjaX,PozycjaY,PozycjaZ);

RysujOstroslup(x0,y0,z0);

//Z bufora na ekran
SwapBuffers(wglGetCurrentDC);
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
Rysuj;
end;

procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
case Key of
  Ord('Q'):  Timer1.Enabled:=not Timer1.Enabled;
  Ord('W'):  RuchKamery:=not RuchKamery;
  VK_ESCAPE: Close;
end;
//obroty
if Shift=[] then
case Key of
  VK_LEFT :Phi:=Phi-3;
  VK_RIGHT :Phi:=Phi+3;
  VK_UP :Theta:=Theta-3;
  VK_DOWN :Theta:=Theta+3;
end;
//przesuniecia
if Shift=[ssCtrl] then
case Key of
  VK_LEFT :PozycjaX:=PozycjaX-0.1;
  VK_RIGHT :PozycjaX:=PozycjaX+0.1;
  VK_UP :PozycjaY:=PozycjaY+0.1;
  VK_DOWN :PozycjaY:=PozycjaY-0.1;
end;
if Shift=[ssShift] then
case Key of
  VK_LEFT :PozycjaX:=PozycjaX-0.1;
  VK_RIGHT :PozycjaX:=PozycjaX+0.1;
  VK_UP :PozycjaZ:=PozycjaZ-0.1;
  VK_DOWN :PozycjaZ:=PozycjaZ+0.1;
end;
//rysowanie
Rysuj;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
Phi:=Phi+1;
Rysuj;
end;

procedure TForm1.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
const PI_2=PI/2.0;
var
  srodek :TPoint;
  dX,dY :Double;
  R,_Phi,_Theta :Double;
begin
if not RuchKamery then Exit;

srodek.X:=ClientWidth div 2;
srodek.Y:=ClientHeight div 2;
dX:=PI_2*(X-srodek.X)/srodek.X;
dY:=-PI_2*(Y-srodek.Y)/srodek.Y; //minus bo wsp. Y jest skierowana inaczej we wsp. ekranu i w XYZ z OpenGL

R:=Sqrt(KameraX*KameraX+KameraY*KameraY+KameraZ*KameraZ);
_Theta:=Sqrt(dX*dX+dY*dY); //To jest przeksztalcenie z 2D kart. do 3D sferyczne (model)
_Phi:=ArcTan2(dY,dX);

KameraX:=R*cos(_Phi)*sin(_Theta);
KameraY:=R*sin(_Phi)*sin(_Theta);
KameraZ:=R*cos(_Theta);

//Caption:='OpenGL '+glGetString(GL_VERSION)+':  Kamera  dX='+FloatToStr(dX)+', dY='+FloatToStr(dY);
Caption:='OpenGL '+glGetString(GL_VERSION)+':  Kamera  odl='+FloatToStr(R)+', Phi='+IntToStr(Round(180*_Phi/PI))+', Theta='+IntToStr(Round(180*_Theta/PI));
//Caption:='OpenGL '+glGetString(GL_VERSION)+':  Kamera (X,Y,Z)=('+FloatToStr(KameraX)+', '+FloatToStr(KameraY)+', '+FloatToStr(KameraZ)+')';
Rysuj;
end;

procedure TForm1.FormMouseWheel(Sender: TObject; Shift: TShiftState;
  WheelDelta: Integer; MousePos: TPoint; var Handled: Boolean);
const wsp=0.1;
begin
//proporcjonalna zmiana pozycji wszystkich wsp. kamery
KameraX:=KameraX*(1+Sign(WheelDelta)*wsp);
KameraY:=KameraY*(1+Sign(WheelDelta)*wsp);
KameraZ:=KameraZ*(1+Sign(WheelDelta)*wsp);
Rysuj;
end;

end.
